<!DOCTYPE html>
<html lang="en">
  <head>
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no" />
    <title>Visitor Log</title>
    <!-- Bootstrap basic: -->
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.3.1/css/bootstrap.min.css" integrity="sha384-ggOyR0iXCbMQv3Xipma34MD+dH/1fQ784/j6cY/iJTQUOhcWr7x9JvoRxT2MZw1T" crossorigin="anonymous">
    <!-- No shortcut icon for this app yet:
    <link rel="shortcut icon" href="images/favicon.ico" type="image/x-icon">
    <link rel="icon" href="images/favicon.ico" type="image/x-icon">
    -->
    </head>
  <body>
    <!-- Generic Modal Dialog: -->
    <div class="modal" id="dialog">
      <div class="modal-dialog">
        <div class="modal-content">
          <!-- Header -->
          <div class="modal-header">
            <h4 class="modal-title" id="dialogTitle"></h4>
            
          </div>
          
          <!-- Body -->
          <div class="modal-body" id="dialogBody"></div>
          
          <!-- Footer -->
          <div class="modal-footer" id="dialogButtons">
            
            <button type="button" class="btn btn-danger" 
              data-dismiss="modal" id="genericButton">Close</button>
            
          </div>
          
        </div>
      </div>
    </div>
    
    <div class="container" id="mainPage">
        <div class="boxed-content row" id="content">
            
        </div>
        <div class="boxed-content row" id="buttons">
            
        </div>
    </div>
    
    <!-- JS files: jQuery first, then Popper.js, then Bootstrap JS -->
    <script src="https://code.jquery.com/jquery-3.3.1.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.14.7/umd/popper.min.js" integrity="sha384-UO2eT0CpHqdSJQ6hJty5KVphtPhzWj9WO1clHTMGa3JDZwrnQq4sF86dIHNDz0W1" crossorigin="anonymous"></script>
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.3.1/js/bootstrap.min.js" integrity="sha384-JjSmVgyd0p3pXB1rRibZUAYoIIy6OrQ6VrjIEaFf/nJGzIxFDsf4x0xIM+B07jRM" crossorigin="anonymous"></script>
    
    <script language="javascript">
        
        var applicationkey = "12345";
        
        var arrFields = new Array();
        var arrHeaders = new Array();
        var arrValidators = new Array();
        
        var submitSuccess = false;
        var submitFields = new Object();
        
        $(document).ready(function() {
            //console.log("Document Ready");
            
            // Make and present Login Dialog
            let titleLogin = "Log In";
            var titleBody = "<p>Name: <input type=\"text\" id=\"loginName\" /></p>";
            titleBody += "<p>Phone: <input type=\"text\" id=\"loginPhone\" /></p>";
            makeDialog(titleLogin, titleBody, "");
            // Process login
            
            
            // Get initialization info: 
            let customername = "Shiner";
            let customerpkey = "12345";
            let url = "https://ibeamma.com/VisitorLog/scripts/initialize.php?" + 
                      "custname=" + customername + 
                      "&custpkey=" + customerpkey + 
                      "&appkey=" + applicationkey;
            console.log(url);
            $.get(url, function(data) {
                let pData = JSON.parse(data);
                //console.log(pData);
                for(var key in pData) {
                    // Fields and Headers arrays: 
                    let field = pData[key];
                    if (field.propname.search("field") != -1) { 
                        arrFields.push(field);
                    } else if (field.propname.search("header") != -1) {
                        arrHeaders.push(field);
                    } else {
                        arrValidators.push(field);
                    }
                    
                    console.log(arrFields);
                    console.log(arrHeaders);
                }
                
                for(var header in arrHeaders) {
                    displayField("content", arrHeaders[header]);
                }
                
                for(var field in arrFields) {
                    //console.log("In Loop, field = " + field)
                    displayField("content", arrFields[field]);
                }
                
                setValidations();
                
                makeSubmitButton("Submit", "buttons");
                //console.log($("#buttons").html());
            });
        });
        
        //~~~~~~~~~~~~~~~~~~~~~~~~~~~//
        function makeDialog(title, body, buttons) {
            //title is text, body and buttons are html
            //buttons is currently unused
            //console.log(title + ", " + body);
            $("#dialogTitle").text(title);
            $("#dialogBody").html(body);
            $("#dialog").modal({backdrop: 'static', keyboard: false});
        }
        
        function displayField(target, field) {
            let targetid = "#" + target;
            let fieldid = "#" + field.propname;
            var fieldHTML = "<div class=\"col-md-6\">";
            fieldHTML += "<p>" + field.value + 
                         "<br /><input type=\"text\" id=\"" + 
                         field.propname + "\" /><br /></p></div>";
            console.log(fieldHTML);
            $(targetid).html( $(targetid).html() + fieldHTML );
            
        }
        
        function setValidations() {
            $("input").blur( function(event) {
                
                arrAllInputs = arrHeaders.concat(arrFields);
                
                var blurredField;
                //get the field that blurred from arrFields:
                for (var input in arrAllInputs) {
                    if (arrAllInputs[input].propname === event.target.id) {
                        blurredField = arrAllInputs[input];
                        break;
                    }
                }
                
                console.log("onBlur..." + blurredField.propname);
                
                //if there is nothing in the field, don't validate it.
                if ( $("#" + blurredField.propname).val().length == 0 ) {
                    console.log("blurred field is empty, disregard.");
                    return;
                }
                
                var procedurename = "";
                var fieldlength = 0;
                var fieldid = "#" + event.target.id;
                var isValid = true;
                
                for (var vToken in arrValidators) {
                    let validator = arrValidators[vToken];
                    console.log("validator.parentkey is " + validator.parentkey);
                    console.log("blurredField.tkey is " + blurredField.tkey);
                    if (validator.parentkey == blurredField.tkey) {
                        console.log(event.target.id + " is being validated.");
                        switch (validator.propname) {
                            case "system validation procedure":
                                procedurename = validator.value;
                                break;
                            case "minimum":
                                fieldlength = $(fieldid).val().length;
                                let minfieldlength = parseInt(validator.value);
                                if (fieldlength < minfieldlength) {
                                    $(fieldid).css("background-color","red");
                                    isValid = false;
                                }
                                break;
                            case "maximum":
                                fieldlength = $(fieldid).val().length;
                                let maxfieldlength = parseInt(validator.value);
                                if (fieldlength > maxfieldlength) {
                                    $(fieldid).css("background-color","red");
                                    isValid = false;
                                }
                                break;
                            default: break;
                        }
                    }
                }
                
                if (isValid) {
                    if (procedurename.length != 0) {
                        //can do server-side validation: 
                        var phpname = procedurename.replace(/spt_/g, "");
                        phpname += ".php";
                        console.log(phpname);
                        //create the url: 
                        var url = `https://ibeamma.com/VisitorLog/scripts/${phpname}?`;
                        url += "applicationkey=" + applicationkey;
                        url += "&fieldname=";
                        url += "&entry=";
                        url += "&tkey=0&tbatchno=0&recordmode=0&companykey=12345";
                        url += "&username=RickWeb&station=1";
                        //add the fields and headers: 
                        for(var field in arrFields) {
                            let f = arrFields[field];
                            url += "&" + f.propname + "=" + 
                                $("#" + f.propname).val();
                        }
                
                        for(var header in arrHeaders) {
                            let h = arrHeaders[header];
                            url += "&" + h.propname + "=" +
                                $("#" + h.propname).val();
                        }
                        console.log(url);
                        
                        $.get(url, function(data) {
                        var objValidatedFields = JSON.parse(data);
                        console.log(objValidatedFields);
                        
                        let allInputs = arrHeaders.concat(arrFields);
                        let validatedKeys = Object.keys(objValidatedFields);
                        
                        for (field in allInputs)
                            if (validatedKeys.includes(allInputs[field].propname)) {
                                $("#" + allInputs[field].propname).val(validatedKeys[field]);
                            }
                        });
                    }
                }
            });
            
            $("input").focus( function(e) {
                $("#" + event.target.id).css("background-color","white");
            });
        }
        
        function makeSubmitButton(name, target) {
            var buttonHTML  = "<button type='button' ";
                buttonHTML += "class='btn btn-primary' >";
                buttonHTML += name + "</button>";
            let t = "#" + target;
            $(t).html(buttonHTML);
            
            $(t).click(function() {
                var url  = "https://ibeamma.com/VisitorLog/scripts/makeentry.php?";
                url += "applicationkey=" + applicationkey;
                url += "&fieldname=";
                url += "&entry=";
                url += "&tkey=0&tbatchno=0&recordmode=0&companykey=12345";
                url += "&username=RickWeb&station=1";
                
                for(var field in arrFields) {
                    let f = arrFields[field];
                    url += "&" + f.propname + "=" + 
                        $("#" + f.propname).val();
                }
                
                for(var header in arrHeaders) {
                    let h = arrHeaders[header];
                    url += "&" + h.propname + "=" +
                        h.value;
                }
                
                console.log(url);
                
                $.get(url, function(data) {
                    //check result
                    let pData = JSON.parse(data);
                    //console.log(pData);
                    for(var key in pData) {
                        // Fields and Headers arrays: 
                        let field = pData[key];
                        console.log("return code is " + field.returncode)
                    }
                });
            });
            
        }
        
    </script>
    
   </body>
 </html>